@extends('frontend.layouts.app')
@push('style')
<style>
    .header-style-two {
        background: rgba(40, 60, 71, 0.40);
    }
</style>
@endpush
@section('content')

<section class="destination">
    <div class="bg-layer"
        style="background: url({{asset('frontend/images/shape/bg-1.webp')}});">
    </div>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-6">
                <x-title :title="__('title.popular-packages')" :desc="__('title.popular-packages-desc')" />
            </div>
        </div>
        <div class="row">
            @forelse ($packages as $package)
            <x-frontend.home.package :package="$package" />
            @empty
            <div class="col-lg-12">
                <div class="alert alert-danger text-center" role="alert">
                    @lang('app.no-package-found')
                </div>
            </div>
            @endforelse
        </div>

        <div class="row d-flex justify-content-center">
            {{ $packages->links() }}
        </div>
    </div>
</section>
@endsection
